﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.VeteranStatusService;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class RegistrantServiceStatusMapper : AHOBPRBaseBO
    {
        string connectionInfo = string.Empty;
        Dictionary<personnelDutyStatusCodeType, string> codes = new Dictionary<personnelDutyStatusCodeType, string>
    {
      {
        personnelDutyStatusCodeType.FullTimeRegActive,
        "Active Duty"
      },
      {
        personnelDutyStatusCodeType.ReserveActiveDutyAgr,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.ReserveActiveDutyNonAgr,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.ReserveNotActiveDuty,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.GuardActiveDutyAgrTitle10,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.GuardActiveDutyNonAgrTitle10,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.GuardActiveDutyAgrTitle32,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.GuardActiveDutyNonAgrTitle32,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.GuardNotActiveDuty,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.ReserveActiveDutyAgrTitle14,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.ReserveActiveDutyNonAgrTitle14,
        "Guard/Reserve"
      },
      {
        personnelDutyStatusCodeType.FormerMilitaryNonDodAffiliated,
        "Separated"
      },
      {
        personnelDutyStatusCodeType.DodRetiree,
        "Retiree"
      },
      {
        personnelDutyStatusCodeType.NonMilitaryPerson,
        "Unkown"
      },
      {
        personnelDutyStatusCodeType.ServiceAcademyStudent,
        "Unkown"
      }
    };
        public RegistrantServiceStatusMapper() { }
        public RegistrantServiceStatusMapper(string dbConnectionInfo)
        {
            this.connectionInfo = dbConnectionInfo;
        }

        public int? GetServiceStatus(string edipi)
        {
            var num = new int?(4); //"Unknown" in the database
            if (!string.IsNullOrEmpty(edipi))
            {
                try
                {
                    using (var db = GetLocalContext(connectionInfo))
                    {
                        if (db == null)
                            throw new ArgumentNullException(nameof(db));

                        VeteranStatus data = GetData(edipi);
                        if (data != null )
                        {
                            if (data?.personDeathIndicatorCode?.ToLower() == "y")
                            {
                                num = db.STD_SERVICE_STATUS.FirstOrDefault(e => e.SERVICE_STATUS == "Deceased")?.STD_SERVICE_STATUS_ID;
                            }
                            else
                            {
                                if (codes.ContainsKey(data.personnelDutyStatusTxt))
                                {
                                    num = db.STD_SERVICE_STATUS.FirstOrDefault(e => e.SERVICE_STATUS == codes[data.personnelDutyStatusTxt])?.STD_SERVICE_STATUS_ID;
                                }
                                else
                                {
                                    AHOBPRLogger.LogErrorMessage("Missing Data", "RegistrantServiceStatusMapper.GetServiceStatus", $"{data?.personnelDutyStatusTxt} not found in STD_SERVICE_STATUS");
                                }
                            }
                            if(num == null)
                            {
                                num = new int?(4);
                            }
                        }
                    }
                }
                catch(NullReferenceException ex)
                {
                    AHOBPRLogger.LogErrorMessage("NullReferenceException", "RegistrantServiceStatusMapper.GetServiceStatus", ex.StackTrace);
                }
                catch (Exception ex)
                {
                    AHOBPRLogger.LogErrorMessage("General Exception", "RegistrantServiceStatusMapper.GetServiceStatus", ex.StackTrace);
                }
            }
            return num;
        }
        public VeteranStatus GetData(string edipi)
        {
            VeteranStatus veteranStatus = null;
            VeteranStatusImporter veteranStatusImporter = new VeteranStatusImporter();
            try
            {
                veteranStatus = veteranStatusImporter.GetVeteranStatus(edipi);
            }
            catch (Exception ex)
            {
                AHOBPRLogger.LogErrorMessage("eMIS Error", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
            }
            return veteranStatus;
        }
    }
}
